/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMinableLargeVein
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final WeightedRandomBlock[] genBlock;
    private final int genVeinSize;
    private final boolean sparse;

    public WorldGenMinableLargeVein(ItemStack itemStack, int n) {
        this(new WeightedRandomBlock(itemStack), n);
    }

    public WorldGenMinableLargeVein(WeightedRandomBlock weightedRandomBlock, int n) {
        this(WorldGenMinableCluster.fabricateList(weightedRandomBlock), n);
    }

    public WorldGenMinableLargeVein(List<WeightedRandomBlock> list, int n) {
        this(list, n, Blocks.stone);
    }

    public WorldGenMinableLargeVein(ItemStack itemStack, int n, Block block) {
        this(new WeightedRandomBlock(itemStack, 1), n, block);
    }

    public WorldGenMinableLargeVein(WeightedRandomBlock weightedRandomBlock, int n, Block block) {
        this(WorldGenMinableCluster.fabricateList(weightedRandomBlock), n, block);
    }

    public WorldGenMinableLargeVein(List<WeightedRandomBlock> list, int n, Block block) {
        this(list, n, WorldGenMinableCluster.fabricateList(block));
    }

    public WorldGenMinableLargeVein(List<WeightedRandomBlock> list, int n, List<WeightedRandomBlock> list2) {
        this(list, n, list2, true);
    }

    public WorldGenMinableLargeVein(List<WeightedRandomBlock> list, int n, List<WeightedRandomBlock> list2, boolean bl) {
        this.cluster = list;
        this.genVeinSize = n;
        this.genBlock = list2.toArray(new WeightedRandomBlock[list2.size()]);
        this.sparse = bl;
    }

    public boolean generate(World world, Random random, int n, int n2, int n3) {
        int n4 = this.genVeinSize;
        int n5 = 1 + n4 / 30;
        int n6 = 1 + n5 / 5;
        boolean bl = false;
        for (int i = 0; i <= n4; ++i) {
            int n7 = n;
            int n8 = n2;
            int n9 = n3;
            int n10 = random.nextInt(6);
            int n11 = -random.nextInt(2);
            int n12 = -random.nextInt(2);
            int n13 = -random.nextInt(2);
            n11 += ~n11 >>> 31;
            n12 += ~n12 >>> 31;
            n13 += ~n13 >>> 31;
            for (int j = 0; j <= n5; ++j) {
                if (n10 != 1) {
                    n7 += random.nextInt(2) * n11;
                }
                if (n10 != 2) {
                    n8 += random.nextInt(2) * n12;
                }
                if (n10 != 3) {
                    n9 += random.nextInt(2) * n13;
                }
                if (random.nextInt(3) == 0) {
                    int n14 = n7;
                    int n15 = n8;
                    int n16 = n9;
                    int n17 = random.nextInt(6);
                    int n18 = -random.nextInt(2);
                    int n19 = -random.nextInt(2);
                    int n20 = -random.nextInt(2);
                    n18 += ~n18 >>> 31;
                    n19 += ~n19 >>> 31;
                    n20 += ~n20 >>> 31;
                    for (int k = 0; k <= n6; ++k) {
                        if (n17 != 0) {
                            n14 += random.nextInt(2) * n18;
                        }
                        if (n17 != 1) {
                            n15 += random.nextInt(2) * n19;
                        }
                        if (n17 != 2) {
                            n16 += random.nextInt(2) * n20;
                        }
                        bl |= WorldGenMinableCluster.generateBlock(world, n14, n15, n16, this.genBlock, this.cluster);
                        if (!this.sparse) continue;
                        ++i;
                        ++j;
                    }
                }
                bl |= WorldGenMinableCluster.generateBlock(world, n7, n8, n9, this.genBlock, this.cluster);
            }
            n += random.nextInt(3) - 1;
            n2 += random.nextInt(3) - 1;
            n3 += random.nextInt(3) - 1;
        }
        return bl;
    }
}

